# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from .sdvalue import *
from .sdapiobject import *
from .sdapiobject import *
from .apiexception import APIException

class SDValueCustom(SDValue):
    """
    Class used to store the data of a custom type as string
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDValueCustom
        """
        super(SDValueCustom, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sNew(typeId : str, valueAsString : str) -> SDValueCustom:
        """
        Create new value from a custom type

        :param typeId: The type name
        :param valueAsString: The string representation of the value that matches the specified type name
        """
        outSDValueCustom = ctypes.c_void_p()
        _res = sd.getContext().SDValueCustom_sNew(ctypes.create_string_buffer(typeId.encode('utf-8')), ctypes.create_string_buffer(valueAsString.encode('utf-8')), ctypes.byref(outSDValueCustom))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outSDValueCustom, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outSDValueCustom.value, ownHandle=True)

